ifndef QCONFIG
QCONFIG=qconfig.mk
endif
include $(QCONFIG)

#===== PINFO - information about the project section.
define PINFO
PINFO DESCRIPTION=Synaptics Touch Driver
endef

USEFILE=

# FOR SYNAPTICS
INCVPATH+=                                                                           \
    $(PROJECT_ROOT)/inc                                                              \

EXTRA_INCVPATH+= $(PROJECT_ROOT)/../../fidm_touch/inc
EXTRA_INCVPATH+= $(PROJECT_ROOT)/../../faceplate/inc

#===== EXTRA_SRCVPATH - a space-separated list of directories to search for source files.
EXTRA_SRCVPATH+=                                                                     \
    $(PROJECT_ROOT)/src                                                              \

ifeq ($(CPULIST), x86_64)

EXTRA_SUFFIXES+=cxx cpp
EXTRA_INCVPATH+=                             \
    ${PROJECT_ROOT}/../../utest/mock/json_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/err_mem/inc \
    ${PROJECT_ROOT}/../../utest/mock/screen_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/i2c_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/gpio_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/input_utest_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/ipc_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/interrupt_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/slog2_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/pthread_mock/inc \
    ${PROJECT_ROOT}/../../utest/specific_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/timer_mock/inc \
    ${PROJECT_ROOT}/../../utest/mock/touchscreen_mock/inc \

#===== EXTRA_SRCVPATH - a space-separated list of directories to search for source files.
EXTRA_SRCVPATH+=                                                                    \
    $(PROJECT_ROOT)/unit_test                                                    \
    ${PROJECT_ROOT}/../../utest/mock/json_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/err_mem/src \
    ${PROJECT_ROOT}/../../utest/mock/gpio_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/i2c_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/interrupt_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/ipc_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/input_utest_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/screen_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/slog2_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/pthread_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/timer_mock/src \
    ${PROJECT_ROOT}/../../utest/mock/touchscreen_mock/src \

SRCS += slog2_mock.cpp err_mem_mock.cpp json_mock.cpp gpio_mock.cpp i2c_mock.cpp interrupt_mock.cpp ipc_mock.cpp input_utest_mock.cpp screen_mock.cpp pthread_mock.cpp touchscreen_mock.cpp syna_tcm2_mtouch.c synaptics_intr.c synaptics_screen.c synaptics_touchcom_core_v1.c synaptics_touchcom_core_v2.c synaptics_touchcom_func_base.c synaptics_touchcom_func_touch.c synaptics_utest.h synaptics_utest.cpp

CXXFLAGS +=-std=c++11 -g -O0 -Wall -fprofile-arcs -ftest-coverage -DUNITTEST

CCFLAGS +=-std=c++11 -g -O0 -Wall -fprofile-arcs -ftest-coverage -DUNITTEST

-include $(QNX_TARGET)/../../../../../vendor/bosch/tools-bosch-shared/unit-test/unittest.mk

#===== LIBS - a space-separated list of library items to be included in the link.
LIBS += gtest gtest_main gcov gmock pthread

NAME=synaptics_utest

else

#===== EXTRA_INCVPATH - a space-separated list of directories to search for include files as part of the staging process.
EXTRA_INCVPATH+=  $(BOSCH_BSP_ROOT)/errmem/errmem_qnx/utility/include \

#===== INCVPATH - a space-separated list of directories to search for include files.
# FOR PUBLIC API HEADER FILES
INCVPATH+=                                                                            \
    $(QNX_TARGET)/usr/include/hw                                                      \
    $(QNX_TARGET)/usr/include/input                                                   \
    $(INSTALL_ROOT_nto)/usr/include/                                                  \
    $(INSTALL_ROOT_nto)/usr/include/amss                                                 \
    $(INSTALL_ROOT_nto)/usr/include/amss/core                                             \
    $(BOSCH_BSP_ROOT)/bsp/input/fidm_touch/inc                                   \
    $(AMSS_ROOT)/inc/                                                                 \
    $(BOSCH_BSP_ROOT)/bsp/input/faceplate/inc                                         \
# FOR TOUCH COMPONENT
INCVPATH+=                                                                            \
    $(PROJECT_ROOT)/inc                                                              \

#===== EXTRA_SRCVPATH - a space-separated list of directories to search for source files.
EXTRA_SRCVPATH+=                                                                     \
    $(PROJECT_ROOT)/src                                                              \

#===== EXTRA_LIBVPATH - a space-separated list of directories to search for library files.
EXTRA_LIBVPATH+=$(QNX_PREBUILT_64)/lib                                                \
        $(PROJECT_ROOT)/../prebuilt                                                   \
        $(INSTALL_ROOT_nto)/aarch64le/lib                                              \
        $(INSTALL_ROOT_nto)/aarch64le/lib/amss                                          \
        $(INSTALL_ROOT_nto)/aarch64le/lib/amss/core/                                  \
        $(BOSCH_BSP_ROOT)/bsp/input/fidm_touch/nto/aarch64/so.le                     \

#===== LIBS - a space-separated list of library items to be included in the link.
LIBS += fidm_touch i2c_clientS gpio_client socket display-binder utils_base $(LIBS_$(subst -,,$(VARIANT_TAG)))

#LIBS_gac += screen

NAME=mtouch-$(PROJECT)
endif

#===== INSTALLDIR - Subdirectory where the executable or library is to be installed.
INSTALLDIR=$(INSTALLDIR_S8155_LIB)

include $(MKFILES_ROOT)/qmacros.mk

include $(MKFILES_ROOT)/qtargets.mk

OPTIMIZE_TYPE_g=none
OPTIMIZE_TYPE=$(OPTIMIZE_TYPE_$(filter g, $(VARIANTS)))

